/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class AnalogDeltaTriggerParameter
extends AnalogTriggerParameter {
    static final long serialVersionUID = -5181381377054570529L;
    private int blockSerializedDataVersion = 1;
    protected int fDelta;
    protected transient AnalogValueProperties fDeltaProperties;

    public AnalogDeltaTriggerParameter() {
    }

    public AnalogDeltaTriggerParameter(Block block) {
        super(block);
    }

    public void setDelta(int delta) {
        this.fDelta = delta;
        this.setOffTrigger(this.getOnTrigger() + this.fDelta);
    }

    public int getDelta() {
        return this.fDelta;
    }

    public void setOnTrigger(int value) {
        super.setOnTrigger(value);
        this.setOffTrigger(value + this.fDelta);
    }

    public AnalogValueProperties getDeltaProperties() {
        if (this.fDeltaProperties == null) {
            this.fDeltaProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.fDelta, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
            return this.fDeltaProperties;
        }
        this.fDeltaProperties.setCurrentValue(this.fDelta);
        this.fDeltaProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        this.fDeltaProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fDeltaProperties;
    }

    public void setDeltaProperties(AnalogValueProperties deltaProperties) {
        this.setDelta(deltaProperties.getCurrentValue());
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDelta = dr.readInt();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDelta);
    }

    public String getParameterText() {
        StringBuffer text = new StringBuffer();
        text.append("Gain=").append(this.getGainString()).append("\n").append("Offset=").append(this.getOffset()).append("\n").append("On=").append(this.getOnTrigger()).append("\n").append("Delta=").append(this.getDelta()).append("\n").append("Point=").append(this.getDecimalPlace());
        return text.toString();
    }

    public String calculateCurrentParameterText() {
        return Util.addTrailingSpaces(Integer.toString(this.fAmplifiedX), 6) + "\n" + this.getOffTrigger();
    }
}

